#include <iostream>
#include <cstdio>
#include <vector>
#include <string>
#include <cmath>
#include <algorithm>
using namespace std;


int myRand()
{
	return ( (rand() << 14) ^ rand() );
}
long long myRandLL()
{
	return ( ( ( (long long) myRand() ) << 30) ^ (long long) myRand() );
}


const int maxn = 2005;
const int maxm = 100500;
int e[maxm][2];
long long eh[maxm];
bool used[maxn];
vector <int> g[maxn];
long long vh[maxn];

int getOth(int eid, int v)
{
	return e[eid][0] + e[eid][1] - v;
}

long long dfs(int v, int pid)
{
	used[v] = true;
	vh[v] = 0;
	for (int i = 0; i < (int) g[v].size(); i++)
	{
		int eid = g[v][i];
		int nv = getOth(eid, v);
		if (used[nv] )
		{
			if (eid != pid)
				vh[v] ^= eh[eid];
			continue;
		}
		vh[v] ^= dfs(nv, eid);
	}
	return vh[v];
}

int main()
{
	freopen("network.in", "r", stdin);
	freopen("network.out", "w", stdout);

	int n, m;
	scanf("%d%d", &n, &m);
	for (int i = 0; i < m; i++)
	{
		scanf("%d%d", &e[i][0], &e[i][1] );
		e[i][0]--;
		e[i][1]--;
		eh[i] = myRandLL();
		g[e[i][0] ].push_back(i);
		g[e[i][1] ].push_back(i);
	}
	dfs(0, -1);
	sort(eh, eh + m);
	sort(vh + 1, vh + n);
	vector <pair <long long, int> > ah;
	int st = 1;
	for (int i = 1; i < n; i++)
	{
		if (i + 1 == n || vh[i + 1] != vh[i] )
		{
			ah.push_back(make_pair(vh[i], i - st + 1) );
			st = i + 1;
			continue;
		}
	}
	long long answer = 0;
	for (int i = 0; i < (int) ah.size(); i++)
	{
		if (ah[i].first == 0)
		{
			int cntB = ah[i].second;
			answer += cntB * 1LL * (cntB - 1) / 2LL + cntB * 1LL * (m - cntB);
			continue;
		}
		answer += ah[i].second * 1LL * (ah[i].second - 1) / 2LL;
		if (binary_search(eh, eh + m, ah[i].first) )
			answer += ah[i].second;
	}
	printf("%lld\n", answer);

	return 0;
}


